## Pipelines solution

~~~
import "StringIO"
import "Apros/Legacy"

isNonemptyString :: String -> Boolean
isNonemptyString = (!= "")

removeComment :: String -> String
removeComment text = (splitString text "!")!0

loadAndPreprocess :: String -> <Proc> [String]
loadAndPreprocess = filter isNonemptyString . map (trim . removeComment) . readLines

isPointEntry entry = (entry!0) == "POINT"
isPipeEntry entry = (entry!0) == "PIPE"

handlePointEntry diagram ["POINT", id, pointElevation, x, y] = do
    name = "PO" + id
    aadd diagram "POINT" name (read x, read y)
    amodi name "PO11_ELEV" pointElevation
    
handlePipeEntry :: String -> (String -> Maybe (Double, Double)) -> Integer -> [String] -> <Proc> ()
handlePipeEntry diagram coordinates id ["PIPE", id1, id2, pipeLength] = do
    name = "PI" + show id
    name1 = "PO" + id1
    name2 = "PO" + id2
    (x1,y1) = fromJust (coordinates id1)
    (x2,y2) = fromJust (coordinates id2)
    aadd diagram "PIPE" name (0.5*(x1+x2), 0.5*(y1+y2))
    amodi name "PI12_CONNECT_POINT_1" name1
    amodi name "PI12_CONNECT_POINT_2" name2
    amodi name "PI12_LENGTH" pipeLength

processFile :: String -> String -> <Proc> ()
processFile diagram fileName = do
    entries = map (flip splitString ";") $ loadAndPreprocess fileName
    
    // Points
    pointEntries = filter isPointEntry entries
    iter (handlePointEntry diagram) pointEntries
    coordinates = index [(id, (read x, read y)) | [_,id,_,x,y] <- pointEntries]
    
    // Pipes 
    pipeEntries = filter isPipeEntry entries
    iterI (handlePipeEntry diagram coordinates) pipeEntries
~~~